#pragma once

#include "BaseShader.h"

using namespace std;
using namespace DirectX;

//Shader used to blend two textures together - used with Bloom
class BlendShader : public BaseShader
{
public:
	BlendShader(ID3D11Device* device, HWND hwnd);
	~BlendShader();

	void setShaderParameters(ID3D11DeviceContext* deviceContext, const XMMATRIX &worldMatrix, const XMMATRIX &viewMatrix, const XMMATRIX &projectionMatrix, ID3D11ShaderResourceView* firstTexture, ID3D11ShaderResourceView* secondTexture);

private:
	void initShader(const wchar_t* vs, const wchar_t* ps);

	ID3D11Buffer* screenBuffer;	//Need to know screen info to calculate texel size
	ID3D11SamplerState* sampleState;
};
